/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Sound sound; // water sound
/******************************************************************************/
void InitPre()
{
   App.name="Sound";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC  ))return false;
   if(Kb.bp(KB_SPACE))SoundPlay("../data/sound/metal.ogg"); // play sound on space

   if(Kb.bp(KB_ENTER)) // toggle water on enter
   {
      if(sound.playing()) // if already playing
      {
         sound.del(); // delete sound
      }else
      {
         sound.play("../data/sound/water.ogg",true); // play with loop option enabled
      }
   }

   // change volumes on mouse wheel
   {
      if(Ms.wheel>0)sound.volume(sound.volume()+0.1);else
      if(Ms.wheel<0)sound.volume(sound.volume()-0.1);
   }

   // change speed on LMB/RMB
   {
      if(Ms.b(0))sound.speed(sound.speed()-Tm.d*0.4);
      if(Ms.b(1))sound.speed(sound.speed()+Tm.d*0.4);
   }
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   D.text (0, 0.2,  "Press space to play 'metal'");
   D.text (0, 0.0,S+"Press enter to stop/play looped 'water' (playing: "     +sound.playing()+')');
   D.text (0,-0.2,S+"Use mouse wheel to change water sound volume (current: "+sound.volume ()+')');
   D.text (0,-0.4,S+  "Press LMB/RMB to change water sound speed (current: " +sound.speed  ()+')');
}
/******************************************************************************/
